<?php
class Model extends Database
{
	protected function resetAiModel($tabela)
	{
		$sql = "ALTER TABLE " . $tabela . " AUTO_INCREMENT = 1;";
		$stmt = $this->connect();
		$query = $stmt->prepare($sql);

		if (!($query->execute())) {
			echo "Erro SQL: " . implode(", ", $query->errorInfo());
			$query = null;
			exit();
		}
		return true;
	}

	protected function insertModel($tabela, $dados)
	{
		$campo = array_keys($dados);
		$valor = array_values($dados);

		$stmt = $this->connect();
		$sql = "INSERT INTO ";
		$sql .= $tabela . " (";
		for ($i = 0; $i < count($campo); $i++) {
			$sql .= $campo[$i];
			if ($i < count($campo) - 1) {
				$sql .= " ,";
			}
		}
		$sql .= ") VALUES (";
		for ($i = 0; $i < count($valor); $i++) {
			$sql .= "?";
			if ($i < count($valor) - 1) {
				$sql .= ", ";
			}
			$valor[$i] = $valor[$i] != '' ? $valor[$i] : null;
		}
		$sql .= ")";
		$query = $stmt->prepare($sql);
		if (!($query->execute($valor))) {
			echo "Erro SQL: " . implode(", ", $query->errorInfo());
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function updateModel($tabela, $dados, $id)
	{
		$idCampo = array_keys($id);
		$idValor = array_values($id);
		$campo = array_keys($dados);
		$valor = array_values($dados);

		$stmt = $this->connect();
		$sql = "UPDATE " . $tabela . " SET ";
		for ($i = 0; $i < count($campo); $i++) {
			$sql .= $campo[$i] . " = " . "?";
			if ($i < count($campo) - 1) {
				$sql .= ", ";
			}
		}
		$sql .= " WHERE ";
		for ($i = 0; $i < count($idCampo); $i++) {
			$sql .= $idCampo[$i] . " = " . "?";
		}
		$query = $stmt->prepare($sql);
		$parametro = array_merge($valor, $idValor);
		if (!($query->execute($parametro))) {
			echo "Erro SQL: " . implode(", ", $query->errorInfo());
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function deleteModel($tabela, $id)
	{
		$idCampo = array_keys($id);
		$idValor = array_values($id);

		$stmt = $this->connect();
		$sql = "DELETE FROM " . $tabela . " WHERE ";
		for ($i = 0; $i < count($idCampo); $i++) {
			$sql .= $idCampo[$i] . " = " . "?";
		}
		$query = $stmt->prepare($sql);
		if (!($query->execute($idValor))) {
			echo "Erro SQL: " . implode(", ", $query->errorInfo());
			$query = null;
			exit();
		}
		$id = $stmt->lastInsertId();
		return $id;
	}

	protected function loginModel($tabela, $dados)
	{
		$campo = array_keys($dados);
		$valor = array_values($dados);

		$data = null;
		$sql = "SELECT * FROM " . $tabela;
		$sql .= " WHERE ";
		$sql .= $campo[0] . " = " . '"' . $valor[0] . '"';
		if ($query = $this->connect()->query($sql)) {
			while ($row = $query->fetch()) {
				$data[] = $row;
			}
		}
		if ($data == false) {
			return "credenciaisInvalidas";
			exit();
		}
		if ($data[0]["senha"] == null) {
			return "semSenha";
			exit();
		}
		$pwdHashed = $data[0]["senha"];
		$checkPwd = password_verify($valor[1], $pwdHashed);
		if ($checkPwd == false) {
			return "credenciaisInvalidas";
			exit();
		} else if ($checkPwd == true) {
			session_start();
			$_SESSION["usuarioId"] = $data[0]["idUsuario"];
			$_SESSION["usuarioIdTipoUsuario"] = $data[0]["idTipoUsuario"];
			$_SESSION["usuarioNome"] = $data[0]["nome"];
			$_SESSION["usuarioImagem"] = $data[0]["imagem"];
			$_SESSION["usuarioEmail"] = $data[0]["email"];
			$_SESSION["usuarioDataAdesao"] = $data[0]["dataAdesao"];
			$_SESSION["usuarioTipoUsuario"] = $data[0]["tipoUsuario"];

			return "success";
			exit();
		}
	}

	protected function selectModel($tabela)
	{
		$data = null;
		$sql = "SELECT * FROM " . $tabela;
		if ($query = $this->connect()->query($sql)) {
			while ($row = $query->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function querySelectModel($tabela, $id)
	{
		if ($tabela === 'viewEntidade') {
			$idCampo = array_keys($id);
			$idValor = array_values($id);

			$data = null;
			$sql = "SELECT viewentidade.*, documento.entregue as valor_adiantado, documento.idTipoDoc as typedoc FROM viewentidade LEFT JOIN documento ON ".$tabela.".idEntidade = documento.idEntidade";
			$sql .= " WHERE viewentidade.";
			for ($i = 0; $i < count($idCampo); $i++) {
				$sql .= $idCampo[$i] . " = " . "?";

				if ($i < count($idCampo) - 1) {
					$sql .= " AND viewentidade.";
				}
			}
			if ($query = $this->connect()->prepare($sql)) {
				$query->execute($idValor);
				while ($row = $query->fetch()) {
					$data[] = $row;
				}
			}
			return $data;
		} else {
			$idCampo = array_keys($id);
			$idValor = array_values($id);

			$data = null;
			$sql = "SELECT * FROM " . $tabela;
			$sql .= " WHERE ";
			for ($i = 0; $i < count($idCampo); $i++) {
				$sql .= $idCampo[$i] . " = " . "?";

				if ($i < count($idCampo) - 1) {
					$sql .= " AND ";
				}
			}
			if ($query = $this->connect()->prepare($sql)) {
				$query->execute($idValor);
				while ($row = $query->fetch()) {
					$data[] = $row;
				}
			}
			return $data;
		}
		
	}

	public function autoIncrementModel($database, $tabela, $alias)
	{
		$data = null;
		$sql = "SELECT `AUTO_INCREMENT` AS '" . $alias . "' FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" . $database . "' AND TABLE_NAME = '" . $tabela . "'";
		if ($query = $this->connect()->query($sql)) {
			while ($row = $query->fetch()) {
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function countModel($tabela, $id)
	{
		$data = null;
		$sql = "SELECT COUNT(*) FROM " . $tabela;
		if ($id != null) {
			$idCampo = array_keys($id);
			$idValor = array_values($id);
			$sql .= " WHERE ";
			for ($i = 0; $i < count($idCampo); $i++) {
				$sql .= $idCampo[$i] . " = " . "?";

				if ($i < count($idCampo) - 1) {
					$sql .= " AND ";
				}
			}
		}
		if ($query = $this->connect()->prepare($sql)) {
			$query->execute($id == null ? null : $idValor);
			while ($row = $query->fetch()) {
				$data[] = $row;
			}
		}

		return $data;
	}
}
